unit Valaszt1u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Felszine: TRadioButton;
    Terfogata: TRadioButton;
    Label1: TLabel;
    GSugar: TEdit;
    GroupBox2: TGroupBox;
    Eredmeny: TEdit;
    Label2: TLabel;
    Kilepes: TButton;
    procedure KilepesClick(Sender: TObject);
    procedure FelszineClick(Sender: TObject);
    procedure TerfogataClick(Sender: TObject);
    procedure GSugarChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    R : real; // a gmb sugara
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function Str2Dbl(const s: string):double;
var  dc : char;
begin
  dc := decimalseparator;
  if pos(',',s) <> 0 then
    decimalseparator := ','
  else
    decimalseparator := '.';
  try
     Str2Dbl := strToFloat(s);
  except
     Str2Dbl := 0;
  end;
  decimalseparator := dc;
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.FelszineClick(Sender: TObject);
begin
   If length(GSugar.Text) <> 0 then
   begin
     R := Str2Dbl(GSugar.Text);
     if R > 0 then
     begin
       Label2.Caption := 'Gmb felszne';
       Eredmeny.Text := FloatToStr(4*sqr(R)*pi);
     end;
   end;
end;

procedure TForm1.TerfogataClick(Sender: TObject);
begin
   If length(GSugar.Text) <> 0 then
   begin
     R := Str2Dbl(GSugar.Text);
     if R > 0 then
     begin
       Label2.Caption := 'Gmb felszne';
       Eredmeny.Text := FloatToStr(4*sqr(R)*R*pi/3);
     end;
   end;
end;

procedure TForm1.GSugarChange(Sender: TObject);
begin
   Eredmeny.Clear;
   Label2.Caption := '';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   // a szvegmez csak olvashat
   Eredmeny.ReadOnly := true;
end;

end.
